/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.IHandlerInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MaidCompatFarmPlantTask<T extends ICompatFarmHandler & IHandlerInfo>
extends Behavior<EntityMaid> {
    private final ICompatFarm<T, ?> task;
    private final T compatFarmHandler;

    public MaidCompatFarmPlantTask(EntityMaid maid, ICompatFarm<T, ?> task) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.task = task;
        this.compatFarmHandler = task.getCompatHandler(maid);
    }

    public MaidCompatFarmPlantTask(EntityMaid maid, ICompatFarm<T, ?> task, T handler) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.task = task;
        this.compatFarmHandler = handler;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Brain brain = owner.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (owner.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty() || !((WalkTarget)walkTarget.get()).m_26420_().m_7024_().equals((Object)targetV3d)) {
                    brain.m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerLevel world, EntityMaid maid, long gameTimeIn) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockPos basePos = posWrapper.m_6675_();
            BlockState cropState = world.m_8055_(basePos);
            if (maid.canDestroyBlock(basePos) && this.task.canHarvest(maid, basePos, cropState, this.compatFarmHandler)) {
                this.task.harvest(maid, basePos, cropState, this.compatFarmHandler);
                maid.m_6674_(InteractionHand.MAIN_HAND);
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            }
        });
    }
}

