/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.mixin;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class MixinManager {
    private static final String MIXIN_PACKAGE = "com.github.wallev.maidsoulkitchen.mixin";
    private static final String FILE_NAME = "maidsoulkitchen-mixins.json";
    private static final String CONFIG_FILE_PATH = String.format("./%s/%s", "config", "maidsoulkitchen-mixins.json");
    public static Map<String, Boolean> mixinList = new HashMap<String, Boolean>();

    private static void putMixin(String mixinClass, boolean enabled) {
        mixinList.put(mixinClass, enabled);
    }

    protected static boolean isMixinEnabled(String mixinClassName) {
        String mixinClassName1 = mixinClassName.replace(String.format("%s.", MIXIN_PACKAGE), "");
        return mixinList.getOrDefault(mixinClassName1, true);
    }

    protected static void loadMixinSettings() {
        File file = new File(CONFIG_FILE_PATH);
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                Type mapType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map existMixinList = (Map)gson.fromJson((Reader)fileReader, mapType);
                mixinList.replaceAll(existMixinList::getOrDefault);
                fileReader.close();
            }
            catch (Exception e) {
                MaidsoulKitchen.LOGGER.warn(String.format("Could not load %s Mixin Configs, creating new config. ERROR: %s", "maidsoulkitchen", e.getLocalizedMessage()));
                MixinManager.saveMixinSettings();
            }
        } else {
            MaidsoulKitchen.LOGGER.warn(String.format("%s Mixin Configs not found, creating new config.", "maidsoulkitchen"));
            MixinManager.saveMixinSettings();
        }
    }

    protected static void saveMixinSettings() {
        Gson gson = new Gson();
        File file = new File(CONFIG_FILE_PATH);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson(mixinList));
            fileWriter.close();
        }
        catch (IOException e) {
            MaidsoulKitchen.LOGGER.warn(String.format("Could not save %s Mixin Configs: %s", "maidsoulkitchen", e.getLocalizedMessage()));
        }
    }

    static {
        MixinManager.putMixin("bakery.MixinSmallCookingPotBlockEntity", true);
        MixinManager.putMixin("beachparty.MixinMiniFridgeBlockEntity", true);
        MixinManager.putMixin("beachparty.MixinTikiBarBlockEntity", true);
        MixinManager.putMixin("candlelight.MixinCookingPanBlockEntity", true);
        MixinManager.putMixin("candlelight.MixinLargeCookingPotBlockEntity", true);
        MixinManager.putMixin("candlelight.MixinStoveBlockEntity", true);
        MixinManager.putMixin("farmacharm.MixinCookingPotBlockEntity", true);
        MixinManager.putMixin("farmacharm.MixinRoastBlockEntity", true);
        MixinManager.putMixin("farmacharm.MixinStoveBlockEntity", true);
        MixinManager.putMixin("herbal.MixinCauldronBlockEntity", true);
        MixinManager.putMixin("herbal.MixinTeaKettleBlockEntity", true);
        MixinManager.putMixin("vinery.MixinFermentationBarrelBlockEntity", true);
        MixinManager.putMixin("fd.MixinCookingPotBlockEntity", true);
        MixinManager.putMixin("md.MixinCopperPotBlockEntity", true);
        MixinManager.putMixin("bnc.KegBlockEntityAccessor", true);
        MixinManager.putMixin("fr.MixinKettleBlockEntity", true);
        MixinManager.putMixin("yhc.KettleBlockAccessor", true);
        MixinManager.putMixin("yhc.MixinBasePotBlockEntity", true);
        MixinManager.putMixin("mc.AbstractFurnaceAccessor", true);
        MixinManager.putMixin("kitchkarrot.AirCompressorBlockEntityAccessor", true);
        MixinManager.putMixin("drinkbeer.BeerBarrelBlockAccessor", true);
    }
}

