/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DropPartModifier
extends LootModifier {
    public static final Codec<DropPartModifier> CODEC = RecordCodecBuilder.create(i -> LootModifier.codecStart((RecordCodecBuilder.Instance)i).and((App)ResourceLocation.f_135803_.fieldOf("entity").forGetter(e -> e.entity)).and((App)ResourceLocation.f_135803_.fieldOf("material").forGetter(e -> e.material)).apply((Applicative)i, DropPartModifier::new));
    private final ResourceLocation entity;
    private final ResourceLocation material;

    protected DropPartModifier(LootItemCondition[] conditionsIn, ResourceLocation entity, ResourceLocation material) {
        super(conditionsIn);
        this.entity = entity;
        this.material = material;
    }

    protected DropPartModifier(ResourceLocation entity, ResourceLocation material, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.entity = entity;
        this.material = material;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> loot, LootContext ctx) {
        if (!ctx.m_78936_(LootContextParams.f_81455_)) {
            return loot;
        }
        Entity e = (Entity)ctx.m_165124_(LootContextParams.f_81455_);
        if (!this.entity.equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()))) {
            return loot;
        }
        MetalGolemPartType type = MetalGolemPartType.values()[ctx.m_230907_().m_188503_(4)];
        loot.add((Object)GolemPart.setMaterial(type.toItem().m_7968_(), this.material));
        return loot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

