/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.config.GolemPartConfig;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemBEWLR;
import dev.xkmc.modulargolems.content.item.golem.IGolemPartItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class GolemPart<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends Item
implements IGolemPartItem {
    public static final List<GolemPart<?, ?>> LIST = new ArrayList();
    private static final String KEY = "golem_material";
    private final Supplier<GolemType<T, P>> type;
    private final P part;
    public final int count;

    public static Optional<ResourceLocation> getMaterial(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).map(e -> e.m_128441_(KEY) ? new ResourceLocation(e.m_128461_(KEY)) : null);
    }

    public static ItemStack setMaterial(ItemStack stack, ResourceLocation material) {
        stack.m_41784_().m_128359_(KEY, material.toString());
        return stack;
    }

    public GolemPart(Item.Properties props, Supplier<GolemType<T, P>> type, P part, int count) {
        super(props.m_41487_(1));
        this.type = type;
        this.part = part;
        this.count = count;
        LIST.add(this);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        GolemPart.getMaterial(stack).ifPresent(e -> {
            GolemMaterial mat = this.parseMaterial((ResourceLocation)e);
            list.add((Component)mat.getDesc());
            int n = mat.modifiers().size();
            mat.modifiers().forEach((m, v) -> {
                list.add(m.getTooltip((int)v));
                if (n == 1 || Screen.m_96638_()) {
                    list.addAll(m.getDetail((int)v));
                }
            });
            mat.stats().forEach((k, v) -> list.add((Component)k.getAdderTooltip((double)v)));
        });
    }

    public GolemMaterial parseMaterial(ResourceLocation mat) {
        HashMap<GolemStatType, Double> magnifier = GolemPartConfig.get().getMagnifier(this.getEntityType());
        HashMap<StatFilterType, Double> filter = GolemPartConfig.get().getFilter(this);
        HashMap<GolemStatType, Double> stats = new HashMap<GolemStatType, Double>();
        HashMap<GolemStatType, Double> matStat = GolemMaterialConfig.get().stats.get(mat);
        if (matStat != null) {
            matStat.forEach((k, v) -> {
                double val = v * filter.getOrDefault((Object)k.type, 1.0) * magnifier.getOrDefault(k, 1.0);
                if (val != 0.0) {
                    stats.compute((GolemStatType)((Object)k), (e, o) -> (o == null ? 0.0 : o) + val);
                }
            });
        }
        HashMap<GolemModifier, Integer> modifiers = new HashMap<GolemModifier, Integer>();
        HashMap<GolemModifier, Integer> matMod = GolemMaterialConfig.get().modifiers.get(mat);
        if (matMod != null) {
            matMod.forEach((k, v) -> {
                if (k.canExistOn(this)) {
                    modifiers.compute((GolemModifier)((Object)k), (e, o) -> (o == null ? 0 : o) + v);
                }
            });
        }
        return new GolemMaterial(stats, modifiers, mat, this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(GolemBEWLR.EXTENSIONS);
    }

    @Override
    public GolemPart<?, ?> asPart() {
        return this;
    }

    public GolemType<T, P> getEntityType() {
        return this.type.get();
    }

    public P getPart() {
        return this.part;
    }

    public void fillItemCategory(CreativeModeTabModifier tab) {
        tab.m_246342_(new ItemStack((ItemLike)this));
        for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            tab.m_246342_(GolemPart.setMaterial(stack, rl));
        }
    }

    public boolean m_41386_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268725_)) {
            return false;
        }
        return super.m_41386_(source);
    }
}

