/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.dog;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemPartType;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DogGolemModel
extends AgeableListModel<DogGolemEntity>
implements IGolemModel<DogGolemEntity, DogGolemPartType, DogGolemModel>,
IHeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart upperBody;

    public DogGolemModel(EntityModelSet set) {
        this(set.m_171103_(GolemEquipmentModels.DOGGOLEM));
    }

    public DogGolemModel(ModelPart part) {
        this.root = part;
        this.head = part.m_171324_("head");
        this.body = part.m_171324_("body");
        this.upperBody = part.m_171324_("upper_body");
        this.rightHindLeg = part.m_171324_("right_hind_leg");
        this.leftHindLeg = part.m_171324_("left_hind_leg");
        this.rightFrontLeg = part.m_171324_("right_front_leg");
        this.leftFrontLeg = part.m_171324_("left_front_leg");
        this.tail = part.m_171324_("tail");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(DogGolemEntity dog, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.tail.f_104203_ = pAgeInTicks;
    }

    public void prepareMobModel(DogGolemEntity dog, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.tail.f_104204_ = dog.m_21660_() ? 0.0f : Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        if (dog.isInSittingPose()) {
            this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
            this.upperBody.f_104203_ = 1.2566371f;
            this.upperBody.f_104204_ = 0.0f;
            this.body.m_104227_(0.0f, 18.0f, 0.0f);
            this.body.f_104203_ = 0.7853982f;
            this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.m_104227_(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.f_104203_ = 4.712389f;
            this.leftHindLeg.m_104227_(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.f_104203_ = 4.712389f;
            this.rightFrontLeg.f_104203_ = 5.811947f;
            this.rightFrontLeg.m_104227_(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.f_104203_ = 5.811947f;
            this.leftFrontLeg.m_104227_(0.51f, 17.0f, -4.0f);
        } else {
            this.body.m_104227_(0.0f, 14.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        }
    }

    @Override
    public void renderToBufferInternal(DogGolemPartType type, PoseStack stack, VertexConsumer consumer, int i, int j, float f1, float f2, float f3, float f4) {
        if (type == DogGolemPartType.BODY) {
            this.body.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.head.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.upperBody.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.tail.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == DogGolemPartType.LEGS) {
            this.leftHindLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.rightHindLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.leftFrontLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.rightFrontLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        }
    }

    @Override
    public ResourceLocation getTextureLocationInternal(ResourceLocation rl) {
        String id = rl.m_135827_();
        String mat = rl.m_135815_();
        return new ResourceLocation(id, "textures/entity/dog_golem/" + mat + ".png");
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    @Override
    public void translateToHead(PoseStack pose) {
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85841_(0.625f, -0.625f, -0.625f);
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

