/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class GolemBannerLayer<T extends AbstractGolemEntity<?, ?>, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final ItemInHandRenderer itemInHandRenderer;

    public GolemBannerLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer iihr) {
        this(parent, 1.0f, 1.0f, 1.0f, iihr);
    }

    public GolemBannerLayer(RenderLayerParent<T, M> parent, float sx, float sy, float sz, ItemInHandRenderer iihr) {
        super(parent);
        this.scaleX = sx;
        this.scaleY = sy;
        this.scaleZ = sz;
        this.itemInHandRenderer = iihr;
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, T entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        Minecraft mc = Minecraft.m_91087_();
        Entity cam = mc.m_91288_();
        if (cam != null && entity.m_20365_(cam)) {
            return;
        }
        ItemStack stack = this.getBanner(entity);
        if (!this.renders(stack)) {
            return;
        }
        pose.m_85836_();
        pose.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
        ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(pose);
        ((IHeadedModel)this.m_117386_()).translateToHead(pose);
        this.itemInHandRenderer.m_269530_(entity, stack, ItemDisplayContext.HEAD, false, pose, buffer, light);
        pose.m_85849_();
    }

    public ItemStack getBanner(T entity) {
        ItemStack stack = entity.m_6844_(EquipmentSlot.HEAD);
        if (entity instanceof HumanoidGolemEntity && this.renders(stack)) {
            return ItemStack.f_41583_;
        }
        Optional<HostileFaction> selfFact = HostileGolemRegistry.tryGetFaction(entity);
        if (selfFact.isPresent()) {
            if (entity.m_146862_(e -> e instanceof AbstractGolemEntity)) {
                return ItemStack.f_41583_;
            }
            return selfFact.get().getBanner((AbstractGolemEntity<?, ?>)((Object)entity), ((AbstractGolemEntity)((Object)entity)).getConfigColor());
        }
        if (entity instanceof MetalGolemEntity && !this.renders(stack)) {
            stack = entity.m_6844_(EquipmentSlot.FEET);
        }
        if (this.renders(stack)) {
            return stack;
        }
        GolemConfigEntry entry = ((AbstractGolemEntity)((Object)entity)).getConfigEntry((Component)MGLangData.LOADING.get(new Object[0]));
        if (entry != null) {
            String color;
            Item item;
            boolean showFlag;
            entry.clientTick(entity.m_9236_(), false);
            UUID captainId = entry.squadConfig.getCaptainId();
            boolean bl = showFlag = captainId != null && entity.m_20148_().equals(captainId);
            if (showFlag && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((color = DyeColor.values()[entry.getColor()].m_41065_()) + "_banner"))) != null) {
                return item.m_7968_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean renders(ItemStack stack) {
        return stack.m_41720_() instanceof BannerItem;
    }
}

