/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.core;

import dev.xkmc.l2library.base.NamedEntry;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;

public class GolemStatType
extends NamedEntry<GolemStatType> {
    private final Supplier<Attribute> attribute;
    public final Kind kind;
    public final StatFilterType type;

    public GolemStatType(Supplier<Attribute> attribute, Kind kind, StatFilterType type) {
        super(GolemTypes.STAT_TYPES);
        this.attribute = attribute;
        this.kind = kind;
        this.type = type;
    }

    public Attribute getAttribute() {
        return this.attribute.get();
    }

    public MutableComponent getAdderTooltip(double val) {
        if (this.kind == Kind.PERCENT) {
            val *= 100.0;
        }
        String key = "attribute.modifier." + (val < 0.0 ? "take." : "plus.") + (this.kind == Kind.PERCENT ? 1 : 0);
        return Component.m_237110_((String)key, (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(val)), Component.m_237115_((String)this.attribute.get().m_22087_())}).m_130940_(ChatFormatting.BLUE);
    }

    public MutableComponent getTotalTooltip(double val) {
        if (this.kind == Kind.PERCENT) {
            val *= 100.0;
        }
        String key = "attribute.modifier." + (val < 0.0 ? "take." : (this.kind == Kind.BASE ? "equals." : "plus.")) + (this.kind == Kind.PERCENT ? 1 : 0);
        return Component.m_237110_((String)key, (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(val)), Component.m_237115_((String)this.attribute.get().m_22087_())}).m_130940_(ChatFormatting.BLUE);
    }

    public void applyToEntity(LivingEntity e, double v) {
        AttributeInstance ins = e.m_21051_(this.attribute.get());
        if (ins == null) {
            return;
        }
        switch (this.kind) {
            case BASE: {
                ins.m_22100_(v);
                break;
            }
            case ADD: {
                ins.m_22100_(ins.m_22135_() + v);
                break;
            }
            case PERCENT: {
                ins.m_22100_(ins.m_22135_() * (1.0 + v));
            }
        }
    }

    public static enum Kind {
        BASE,
        ADD,
        PERCENT;

    }
}

