/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.tracker;

import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class TrackerInfo {
    public static Component getDesc(GolemTracker.TrackedData data) {
        float f = Mth.m_14036_((float)(data.hp / data.mhp), (float)0.0f, (float)1.0f);
        int color = Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)0.5f);
        MutableComponent hc = Component.m_237113_((String)("" + Math.round(data.hp))).m_6270_(Style.f_131099_.m_178520_(color));
        MutableComponent hpText = hc.m_7220_((Component)Component.m_237113_((String)("/" + Math.round(data.mhp))).m_130940_(data.hp <= 0.0f ? ChatFormatting.DARK_RED : ChatFormatting.DARK_AQUA));
        return data.name == null ? hpText : Component.Serializer.m_130701_((String)data.name).m_130946_(": ").m_7220_((Component)hpText);
    }

    public static List<Component> getDetail(GolemTracker.TrackedData data, Player player, long time) {
        ArrayList<Component> ans = new ArrayList<Component>();
        if (data.name != null) {
            ans.add((Component)Component.Serializer.m_130701_((String)data.name));
        }
        float f = Mth.m_14036_((float)(data.hp / data.mhp), (float)0.0f, (float)1.0f);
        int color = Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)0.5f);
        MutableComponent hc = Component.m_237113_((String)("" + Math.round(data.hp))).m_6270_(Style.f_131099_.m_178520_(color));
        ans.add((Component)MGLangData.HEALTH.get(hc, Math.round(data.mhp)).m_130940_(data.hp <= 0.0f ? ChatFormatting.DARK_RED : ChatFormatting.DARK_AQUA));
        if (data.hp > 0.0f) {
            long diff = (time - data.timestamp) / 20L;
            ans.add((Component)(diff < 2L ? MGLangData.TRACKER_PRESENT.get(new Object[0]).m_130940_(ChatFormatting.DARK_GREEN) : MGLangData.TRACKER_TIME.get(new Object[0]).m_130940_(ChatFormatting.RED)));
        }
        boolean diffDim = !data.lastDim.equals((Object)player.m_9236_().m_46472_().m_135782_());
        BlockPos p = data.lastPos;
        boolean tooFar = diffDim || p.m_123331_((Vec3i)player.m_20183_()) > 16384.0;
        ans.add((Component)MGLangData.TRACKER_DIM.get(data.lastDim.toString()).m_130940_(diffDim ? ChatFormatting.RED : ChatFormatting.GRAY));
        ans.add((Component)MGLangData.TRACKER_POS.get(p.m_123341_(), p.m_123342_(), p.m_123343_()).m_130940_(tooFar ? ChatFormatting.RED : ChatFormatting.GRAY));
        ans.add((Component)TrackerInfo.getStatusDesc(data));
        if (data.golemType != null) {
            IGolemPart[] parts = data.golemType.values();
            if (data.materials.size() == parts.length) {
                for (int i = 0; i < parts.length; ++i) {
                    ResourceLocation id = data.materials.get(i);
                    ans.add((Component)parts[i].getDesc(Component.m_237115_((String)("golem_material." + id.m_135827_() + "." + id.m_135815_())).m_130940_(ChatFormatting.GOLD)));
                }
            }
        }
        return ans;
    }

    private static MutableComponent getStatusDesc(GolemTracker.TrackedData data) {
        return switch (data.status) {
            default -> throw new IncompatibleClassChangeError();
            case GolemTracker.Status.ALIVE -> MGLangData.TRACKER_ALIVE.get(new Object[0]).m_130940_(ChatFormatting.GRAY);
            case GolemTracker.Status.RETRIEVED -> MGLangData.TRACKER_RETRIEVED.get(new Object[0]).m_130940_(ChatFormatting.GRAY);
            case GolemTracker.Status.OTHER_RETRIEVED -> {
                if (data.cause == null) {
                    yield MGLangData.TRACKER_RETRIEVED.get(new Object[0]).m_130940_(ChatFormatting.GRAY);
                }
                yield MGLangData.TRACKER_RETRIEVED_OTHER.get(Component.Serializer.m_130701_((String)data.cause)).m_130940_(ChatFormatting.GRAY);
            }
            case GolemTracker.Status.DEATH -> {
                if (data.cause == null) {
                    yield MGLangData.TRACKER_DIED.get(new Object[0]).m_130940_(ChatFormatting.RED);
                }
                yield MGLangData.TRACKER_KILLED.get(Component.Serializer.m_130701_((String)data.cause)).m_130940_(ChatFormatting.RED);
            }
            case GolemTracker.Status.DEATH_RECYCLE -> data.cause == null ? MGLangData.TRACKER_RECYCLE_DIED.get(new Object[0]).m_130940_(ChatFormatting.RED) : MGLangData.TRACKER_RECYCLE_KILLED.get(Component.Serializer.m_130701_((String)data.cause)).m_130940_(ChatFormatting.RED);
        };
    }
}

