/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.capability.ConfigSyncToClient;
import dev.xkmc.modulargolems.content.capability.ConfigUpdateToServer;
import dev.xkmc.modulargolems.content.capability.PathConfig;
import dev.xkmc.modulargolems.content.capability.PickupFilterConfig;
import dev.xkmc.modulargolems.content.capability.SquadConfig;
import dev.xkmc.modulargolems.content.capability.SyncContainer;
import dev.xkmc.modulargolems.content.capability.TargetFilterConfig;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GolemConfigEntry {
    public final SyncContainer sync = new SyncContainer();
    private UUID id;
    private int color;
    private Component nameComp;
    @SerialClass.SerialField
    protected String name;
    @SerialClass.SerialField
    public int defaultMode;
    @SerialClass.SerialField
    public boolean summonToPosition;
    @SerialClass.SerialField
    public boolean locked;
    @SerialClass.SerialField
    public PickupFilterConfig pickupFilter = new PickupFilterConfig();
    @SerialClass.SerialField
    public TargetFilterConfig targetFilter = new TargetFilterConfig();
    @SerialClass.SerialField
    public SquadConfig squadConfig = new SquadConfig();
    @SerialClass.SerialField
    public PathConfig pathConfig = new PathConfig();

    public static GolemConfigEntry getDefault(UUID id, int color, Component name) {
        return new GolemConfigEntry(name).init(id, color);
    }

    @Deprecated
    public GolemConfigEntry() {
    }

    private GolemConfigEntry(Component comp) {
        this.nameComp = comp;
        this.name = Component.Serializer.m_130703_((Component)comp);
        this.targetFilter.initDefault();
    }

    public Component getDisplayName() {
        if (this.nameComp == null) {
            this.nameComp = Component.Serializer.m_130701_((String)this.name);
        }
        if (this.nameComp == null) {
            this.nameComp = Component.m_237113_((String)"Unnamed");
        }
        return this.nameComp;
    }

    public GolemConfigEntry init(UUID id, int color) {
        this.id = id;
        this.color = color;
        return this;
    }

    public void heartBeat(ServerLevel level, ServerPlayer player) {
        if (this.sync.heartBeat(level, player.m_20148_())) {
            ModularGolems.HANDLER.toClientPlayer((SimplePacketBase)new ConfigSyncToClient(this), player);
        }
    }

    public UUID getID() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public void clientTick(Level level, boolean updated) {
        this.sync.clientTick(this, level, updated);
    }

    public void sync(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.sync.sendToAllTracking(sl, new ConfigSyncToClient(this));
        } else {
            ModularGolems.HANDLER.toServer((SimplePacketBase)new ConfigUpdateToServer(level, this));
        }
    }

    public GolemConfigEntry copyFrom(@Nullable GolemConfigEntry entry) {
        if (entry != null) {
            this.sync.clientReplace(entry.sync);
        }
        return this;
    }

    public void setName(Component hoverName, ServerLevel level) {
        this.nameComp = hoverName;
        this.name = Component.Serializer.m_130703_((Component)hoverName);
        this.sync((Level)level);
    }
}

