/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.modulargolems.compat.maid.GolemSummonUtils;
import dev.xkmc.modulargolems.events.event.GolemToOwnerEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidRegistry {
    public static final RegistryEntry<MemoryModuleType<List<UUID>>> GOLEMS = ModularGolems.REGISTRATE.simple("golem_ids", Registries.f_257023_, () -> new MemoryModuleType(Optional.of(UUIDUtil.f_235867_.listOf())));

    @SubscribeEvent
    public static void onGolemReturn(GolemToOwnerEvent event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getOwner();
        if (livingEntity instanceof EntityMaid && GolemSummonUtils.returnToInv(maid = (EntityMaid)livingEntity, event.getStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void maidTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            CombinedInvWrapper inv = maid.getAvailableInv(false);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!stack.m_204117_(MGTagGen.GOLEM_HOLDERS)) continue;
                stack.m_41666_(maid.m_9236_(), (Entity)maid, i, false);
                inv.setStackInSlot(i, stack);
            }
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register(MaidRegistry.class);
    }
}

