/*
 * Decompiled with CFR 0.152.
 */
package com.morallenplay.vanillacookbook.setup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.morallenplay.vanillacookbook.registry.RecipeRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class SetRemainderRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    final NonNullList<ItemStack> contained;
    final NonNullList<ItemStack> remainder;
    private final boolean isSimple;

    public SetRemainderRecipe(ResourceLocation location, String group, CraftingBookCategory category, ItemStack output, NonNullList<Ingredient> ingredient, NonNullList<ItemStack> contained, NonNullList<ItemStack> container) {
        this.id = location;
        this.group = group;
        this.category = category;
        this.result = output;
        this.ingredients = ingredient;
        this.contained = contained;
        this.remainder = container;
        this.isSimple = ingredient.stream().allMatch(Ingredient::isSimple);
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public boolean matches(CraftingContainer c, Level level) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < c.m_6643_(); ++j) {
            ItemStack itemstack = c.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.m_36475_((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack assemble(CraftingContainer c, RegistryAccess a) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return p_43999_ * p_44000_ >= this.ingredients.size();
    }

    public ItemStack m_8043_(RegistryAccess a) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            for (int j = 0; j < this.contained.size(); ++j) {
                if (!((ItemStack)this.contained.get(j)).m_150930_(item.m_41720_())) continue;
                if (((ItemStack)this.remainder.get(j)).m_150930_(Items.f_42684_.m_7968_().m_41720_())) {
                    ItemStack itemstack = item.m_41777_();
                    itemstack.m_41764_(1);
                    nonnulllist.set(i, (Object)itemstack);
                    continue;
                }
                nonnulllist.set(i, (Object)((ItemStack)this.remainder.get(j)).m_41777_());
            }
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.SET_REMAINDER_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SetRemainderRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");

        public SetRemainderRecipe fromJson(ResourceLocation location, JsonObject object) {
            String s = GsonHelper.m_13851_((JsonObject)object, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)object, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)object, (String)"ingredients"));
            NonNullList<ItemStack> contained = Serializer.containItemFromJson(GsonHelper.m_13933_((JsonObject)object, (String)"contained"));
            NonNullList<ItemStack> containers = Serializer.containItemFromJson(GsonHelper.m_13933_((JsonObject)object, (String)"containers"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"result"));
            return new SetRemainderRecipe(location, s, craftingbookcategory, itemstack, nonnulllist, contained, containers);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<ItemStack> containItemFromJson(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                ItemStack item = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13918_((JsonElement)array.get(i), null));
                nonnulllist.add((Object)item);
            }
            return nonnulllist;
        }

        public SetRemainderRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf bytebuf) {
            String s = bytebuf.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)bytebuf.m_130066_(CraftingBookCategory.class);
            int i = bytebuf.m_130242_();
            int j = bytebuf.m_130242_();
            int k = bytebuf.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            NonNullList contained = NonNullList.m_122780_((int)j, (Object)ItemStack.f_41583_);
            NonNullList containers = NonNullList.m_122780_((int)k, (Object)ItemStack.f_41583_);
            for (int l = 0; l < nonnulllist.size(); ++l) {
                nonnulllist.set(l, (Object)Ingredient.m_43940_((FriendlyByteBuf)bytebuf));
            }
            for (int m = 0; m < contained.size(); ++m) {
                contained.set(m, (Object)bytebuf.m_130267_());
            }
            for (int n = 0; n < containers.size(); ++n) {
                containers.set(n, (Object)bytebuf.m_130267_());
            }
            ItemStack itemstack = bytebuf.m_130267_();
            return new SetRemainderRecipe(location, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist, (NonNullList<ItemStack>)contained, (NonNullList<ItemStack>)containers);
        }

        public void toNetwork(FriendlyByteBuf bytebuf, SetRemainderRecipe recipe) {
            bytebuf.m_130070_(recipe.group);
            bytebuf.m_130068_((Enum)recipe.category);
            bytebuf.m_130130_(recipe.ingredients.size());
            bytebuf.m_130130_(recipe.contained.size());
            bytebuf.m_130130_(recipe.remainder.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(bytebuf);
            }
            for (ItemStack contained : recipe.contained) {
                bytebuf.m_130055_(contained);
            }
            for (ItemStack containers : recipe.remainder) {
                bytebuf.m_130055_(containers);
            }
            bytebuf.m_130055_(recipe.result);
        }
    }
}

