/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.registry;

import com.majruszlibrary.annotation.Dist;
import com.majruszlibrary.annotation.OnlyIn;
import com.majruszlibrary.mixin.IMixinCriteriaTriggers;
import com.majruszlibrary.modhelper.DataForge;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.registry.Custom;
import com.majruszlibrary.registry.IRegistryPlatform;
import com.majruszlibrary.registry.RegistryCallbacks;
import com.majruszlibrary.registry.RegistryGroup;
import com.majruszlibrary.registry.RegistryObject;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class RegistryForge
implements IRegistryPlatform {
    @Override
    public <Type> void register(RegistryGroup<Type> group) {
        DataForge data = group.helper.getData(DataForge.class);
        data.lastDeferredRegister = DeferredRegister.create((ResourceKey)group.registry.m_123023_(), (String)group.helper.getModId());
        data.lastDeferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @Override
    public <Type> void register(RegistryObject<Type> object) {
        DataForge data = object.group.helper.getData(DataForge.class);
        net.minecraftforge.registries.RegistryObject forgeObject = data.lastDeferredRegister.register(object.id, object.newInstance);
        object.set((Supplier<Type>)forgeObject, () -> ((net.minecraftforge.registries.RegistryObject)forgeObject).isPresent());
    }

    @Override
    public void register(RegistryCallbacks callbacks) {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(event -> {
            callbacks.execute(Custom.Advancements.class, IMixinCriteriaTriggers::register);
            callbacks.execute(Custom.PotionRecipe.class, new Custom.PotionRecipe(){

                @Override
                public void register(final Supplier<? extends Potion> input, final Supplier<? extends Item> item, final Supplier<? extends Potion> output) {
                    BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new IBrewingRecipe(){

                        public boolean isInput(ItemStack itemStack) {
                            return PotionUtils.m_43579_((ItemStack)itemStack).equals(input.get());
                        }

                        public boolean isIngredient(ItemStack itemStack) {
                            return itemStack.m_41720_().equals(item.get());
                        }

                        public ItemStack getOutput(ItemStack input2, ItemStack ingredient) {
                            return this.isInput(input2) && this.isIngredient(ingredient) ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)input2.m_41720_()), (Potion)((Potion)output.get())) : ItemStack.f_41583_;
                        }
                    });
                }
            });
        });
        eventBus.addListener(event -> callbacks.execute(Custom.Attributes.class, (arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        eventBus.addListener(event -> callbacks.execute(Custom.SpawnPlacements.class, new Custom.SpawnPlacements(){
            final /* synthetic */ SpawnPlacementRegisterEvent val$event;
            {
                this.val$event = spawnPlacementRegisterEvent;
            }

            @Override
            public <Type extends Mob> void register(EntityType<Type> entityType, SpawnPlacements.Type type, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<Type> predicate) {
                this.val$event.register(entityType, type, heightmap, predicate, SpawnPlacementRegisterEvent.Operation.AND);
            }
        }));
        Side.runOnClient(() -> () -> {
            eventBus.addListener(event -> {
                callbacks.execute(Custom.ItemProperties.class, ItemProperties::register);
                callbacks.execute(Custom.ModelLayers.class, ForgeHooksClient::registerLayerDefinition);
                callbacks.execute(Custom.Renderers.class, EntityRenderers::m_174036_);
            });
            eventBus.addListener(event -> callbacks.execute(Custom.Particles.class, new CustomParticles((RegisterParticleProvidersEvent)event)));
        });
    }

    @Override
    public IRegistryPlatform.IAccessor<Item> getItems() {
        return new Accessor<Item>(ForgeRegistries.ITEMS);
    }

    @Override
    public IRegistryPlatform.IAccessor<MobEffect> getEffects() {
        return new Accessor<MobEffect>(ForgeRegistries.MOB_EFFECTS);
    }

    @Override
    public IRegistryPlatform.IAccessor<Enchantment> getEnchantments() {
        return new Accessor<Enchantment>(ForgeRegistries.ENCHANTMENTS);
    }

    @Override
    public IRegistryPlatform.IAccessor<EntityType<?>> getEntityTypes() {
        return new Accessor(ForgeRegistries.ENTITY_TYPES);
    }

    @Override
    public IRegistryPlatform.IAccessor<SoundEvent> getSoundEvents() {
        return new Accessor<SoundEvent>(ForgeRegistries.SOUND_EVENTS);
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    private static class Accessor<Type>
    implements IRegistryPlatform.IAccessor<Type> {
        private final IForgeRegistry<Type> registry;

        public Accessor(IForgeRegistry<Type> registry) {
            this.registry = registry;
        }

        @Override
        public ResourceLocation getId(Type value) {
            return this.registry.getKey(value);
        }

        @Override
        public Type get(ResourceLocation id) {
            return (Type)this.registry.getValue(id);
        }

        @Override
        public Iterable<Type> get() {
            return this.registry;
        }

        @Override
        public Holder<Type> getHolder(Type value) {
            return (Holder)this.registry.getHolder(value).orElseThrow();
        }

        @Override
        @NotNull
        public Iterator<Type> iterator() {
            return this.registry.iterator();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CustomParticles
    implements Custom.Particles {
        final RegisterParticleProvidersEvent event;

        public CustomParticles(RegisterParticleProvidersEvent event) {
            this.event = event;
        }

        @Override
        public <Type extends ParticleOptions> void register(ParticleType<Type> type, Function<SpriteSet, ParticleProvider<Type>> factory) {
            this.event.registerSpriteSet(type, factory::apply);
        }
    }
}

