/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.FileUtil;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class DynamicPackResources
extends AbstractModPackResources {
    public static final Map<String, PackType> PATHS_FOR_TYPE = (Map)Arrays.stream(PackType.values()).collect(ImmutableMap.toImmutableMap(PackType::m_10305_, Function.identity()));
    protected final DataProviderContext.Factory[] factories;
    protected Map<PackType, Map<ResourceLocation, IoSupplier<InputStream>>> paths;

    protected DynamicPackResources(DataProviderContext.Factory ... factories) {
        this.factories = factories;
    }

    public static Supplier<AbstractModPackResources> create(DataProviderContext.Factory ... factories) {
        return () -> new DynamicPackResources(factories);
    }

    public static Map<PackType, Map<ResourceLocation, IoSupplier<InputStream>>> generatePathsFromProviders(String modId, DataProviderContext.Factory ... factories) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            EnumMap<PackType, Map> paths = new EnumMap<PackType, Map>(PackType.class);
            DataProviderContext context = DataProviderContext.fromModId(modId);
            for (DataProviderContext.Factory factory : factories) {
                ((DataProvider)factory.apply(context)).m_213708_((filePath, data, hashCode) -> {
                    List strings = FileUtil.m_245538_((String)filePath.normalize().toString().replace(File.separator, "/")).result().filter(list -> list.size() >= 2).orElse(null);
                    if (strings != null) {
                        PackType packType = PATHS_FOR_TYPE.get(strings.get(0));
                        Objects.requireNonNull(packType, () -> "pack type for directory %s is null".formatted(strings.get(0)));
                        String path = strings.stream().skip(2L).collect(Collectors.joining("/"));
                        ResourceLocation resourceLocation = ResourceLocation.m_214293_((String)((String)strings.get(1)), (String)path);
                        if (resourceLocation != null) {
                            paths.computeIfAbsent(packType, $ -> new ConcurrentHashMap()).put(resourceLocation, () -> new ByteArrayInputStream(data));
                        }
                    }
                }).join();
            }
            paths.replaceAll((packType, map) -> ImmutableMap.copyOf((Map)map));
            PuzzlesLib.LOGGER.info("Data generation for dynamic pack resources provided by '{}' took {}ms", (Object)modId, (Object)stopwatch.stop().elapsed().toMillis());
            return Maps.immutableEnumMap(paths);
        }
        catch (Throwable throwable) {
            PuzzlesLib.LOGGER.warn("Unable to complete data generation for dynamic pack resources provided by '{}'", (Object)modId, (Object)throwable);
            return Collections.emptyMap();
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    protected void setup() {
    }

    protected Map<ResourceLocation, IoSupplier<InputStream>> getPathsForType(PackType packType) {
        Map<PackType, Map<ResourceLocation, IoSupplier<InputStream>>> paths = this.paths;
        if (paths == null) {
            paths = this.paths = this.generatePathsFromProviders();
        }
        return paths.getOrDefault(packType, Collections.emptyMap());
    }

    protected Map<PackType, Map<ResourceLocation, IoSupplier<InputStream>>> generatePathsFromProviders() {
        return DynamicPackResources.generatePathsFromProviders(this.getNamespace(), this.factories);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        return this.getPathsForType(packType).get(location);
    }

    @Override
    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        this.getPathsForType(packType).entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals(namespace) && ((ResourceLocation)entry.getKey()).m_135815_().startsWith(path)).forEach(entry -> resourceOutput.accept((Object)((ResourceLocation)entry.getKey()), (Object)((IoSupplier)entry.getValue())));
    }

    @Override
    public Set<String> m_5698_(PackType packType) {
        return this.getPathsForType(packType).keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }
}

