/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryReloadEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import org.jetbrains.annotations.Nullable;

public class IMCHandler {
    private static final Map<String, ImcRegistrations> registrations = new HashMap<String, ImcRegistrations>();

    private static ImcRegistrations prepareImcRegistrations(String id) {
        if (registrations.isEmpty()) {
            Balm.getEvents().onEvent(MarketRegistryReloadEvent.Pre.class, event -> registrations.values().forEach(it -> FarmingForBlockheadsAPI.registerMarketDefaultHandler(it.id, it)));
        }
        return registrations.computeIfAbsent(id, s -> new ImcRegistrations(id));
    }

    public static void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String sender = message.senderModId();
            Object obj = message.messageSupplier().get();
            switch (message.method()) {
                case "RegisterMarketCategory": {
                    if (obj instanceof CompoundTag) {
                        CompoundTag tagCompound = (CompoundTag)obj;
                        ResourceLocation registryName = new ResourceLocation(tagCompound.m_128461_("RegistryName"));
                        if (registryName.m_135827_().equals(sender)) {
                            String tooltipLangKey = tagCompound.m_128425_("Tooltip", 8) ? tagCompound.m_128461_("Tooltip") : "gui.farmingforblockheads:market.tooltip_none";
                            ItemStack icon = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Icon"));
                            int sortIndex = tagCompound.m_128451_("SortIndex");
                            IMCHandler.prepareImcRegistrations(sender + "_imc").addCategory(new ImcMarketCategoryRegistration(registryName, tooltipLangKey, icon, sortIndex));
                            break;
                        }
                        FarmingForBlockheads.logger.error("IMC API Error: Market category must be prefixed by your mod id (from {})", (Object)sender);
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                    break;
                }
                case "RegisterMarketEntry": {
                    if (obj instanceof CompoundTag) {
                        CompoundTag tagCompound = (CompoundTag)obj;
                        if (!tagCompound.m_128425_("OutputItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires OutputItem tag (from {})", (Object)sender);
                            break;
                        }
                        if (!tagCompound.m_128425_("CostItem", 10)) {
                            FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry requires CostItem tag (from {})", (Object)sender);
                            break;
                        }
                        ItemStack outputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("OutputItem"));
                        ItemStack costItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("CostItem"));
                        ResourceLocation categoryId = tagCompound.m_128425_("Category", 8) ? new ResourceLocation(tagCompound.m_128461_("Category")) : FarmingForBlockheadsAPI.MARKET_CATEGORY_OTHER;
                        IMCHandler.prepareImcRegistrations(sender + "_imc").addEntry(new ImcMarketEntryRegistration(outputItem, costItem, categoryId));
                        break;
                    }
                    FarmingForBlockheads.logger.error("IMC API Error: RegisterMarketEntry expects NBT (from {})", (Object)sender);
                }
            }
        });
    }

    public static class ImcRegistrations
    implements IMarketRegistryDefaultHandler {
        private final String id;
        private final List<ImcMarketCategoryRegistration> categories = new ArrayList<ImcMarketCategoryRegistration>();
        private final List<ImcMarketEntryRegistration> entries = new ArrayList<ImcMarketEntryRegistration>();

        public ImcRegistrations(String id) {
            this.id = id;
        }

        @Override
        public void register(@Nullable ItemStack overridePayment, @Nullable Integer overrideCount) {
            this.categories.forEach(registration -> FarmingForBlockheadsAPI.registerMarketCategory(registration.registryName, registration.tooltipLangKey, registration.icon, registration.sortIndex));
            this.entries.forEach(registration -> {
                IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(registration.categoryId);
                if (category != null) {
                    ItemStack effectiveOutputItem = overrideCount != null ? new ItemStack((ItemLike)registration.outputItem.m_41720_(), overrideCount.intValue()) : registration.outputItem;
                    ItemStack effectiveCostItem = overridePayment != null ? overridePayment : registration.costItem;
                    FarmingForBlockheadsAPI.registerMarketEntry(effectiveOutputItem, effectiveCostItem, category);
                } else {
                    FarmingForBlockheads.logger.error("IMC API Error: Market category {} does not exist (from {})", (Object)registration.categoryId, (Object)this.id);
                }
            });
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        public void addCategory(ImcMarketCategoryRegistration registration) {
            this.categories.add(registration);
        }

        public void addEntry(ImcMarketEntryRegistration registration) {
            this.entries.add(registration);
        }
    }

    private record ImcMarketCategoryRegistration(ResourceLocation registryName, String tooltipLangKey, ItemStack icon, int sortIndex) {
    }

    private record ImcMarketEntryRegistration(ItemStack outputItem, ItemStack costItem, ResourceLocation categoryId) {
    }
}

