/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    private static final ResourceLocation BARS_TEXTURE = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("tslatentitystatus", "textures/gui/tes_icons.png");

    public static int renderEntityName(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud) {
            if (!(TESAPI.getConfig().inWorldHudEntityName() || TESConstants.CONFIG.inWorldHudNameOverride() && entity.m_8077_())) {
                return 0;
            }
            TESClientUtil.centerTextForRender(entity.m_5446_(), 0.0f, 0.0f, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.f_91062_, guiGraphics.m_280168_(), entity.m_5446_(), x.floatValue(), y.floatValue(), FastColor.ARGB32.m_13660_((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.m_280091_()));
        } else {
            if (!TESAPI.getConfig().hudEntityName()) {
                return 0;
            }
            TESAPI.getConfig().hudEntityNameFontStyle().render(mc.f_91062_, guiGraphics.m_280168_(), entity.m_5446_(), 0.0f, 0.0f, FastColor.ARGB32.m_13660_((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.m_280091_());
        }
        TESEntityTracking.markNameRendered(entity);
        guiGraphics.m_280091_().m_173043_();
        Objects.requireNonNull(mc.f_91062_);
        return 9;
    }

    public static int renderEntityHealth(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (inWorldHud) {
            poseStack.m_252880_((float)barWidth * -0.5f, 0.0f, 0.0f);
            poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        }
        TESClientUtil.prepRenderForTexture(BARS_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.enableDepthTest();
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float percentHealth = entityState.getHealth() / entity.m_21233_();
            float percentTransitionHealth = entityState.getLastTransitionHealth() / entity.m_21233_();
            boolean doSegments = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            int uvY = TESConstants.UTILS.getEntityType(entity).getTextureYPos();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, 60, 1.0f, false, opacity);
            poseStack.m_252880_(0.0f, 0.0f, 0.001f);
            if (percentTransitionHealth > percentHealth) {
                TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, uvY, entityState.getLastTransitionHealth() / entity.m_21233_(), false, opacity);
            }
            poseStack.m_252880_(0.0f, 0.0f, 0.001f);
            RenderSystem.enableBlend();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, uvY + 5, percentHealth, doSegments, opacity);
        }
        if (renderType != TESHud.BarRenderType.BAR) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.m_21233_(), 1);
            float halfTextWidth = (float)mc.f_91062_.m_92895_(healthText) / 2.0f;
            float center = (float)barWidth / 2.0f;
            RenderSystem.setShader(GameRenderer::m_172811_);
            poseStack.m_252880_(0.0f, 0.0f, 0.001f);
            TESClientUtil.drawColouredSquare(guiGraphics, (int)(center - halfTextWidth - 1.0f), -2, (int)(halfTextWidth * 2.0f) + 1, 9, 0x90909 | (int)(opacity * 255.0f * TESConstants.CONFIG.hudBarFontBackingOpacity()) << 24);
            poseStack.m_252880_(0.0f, 0.0f, 0.001f);
            (inWorldHud ? TESAPI.getConfig().inWorldHudHealthFontStyle() : TESAPI.getConfig().hudHealthFontStyle()).render(mc.f_91062_, guiGraphics.m_280168_(), (Component)Component.m_237113_((String)healthText), center - halfTextWidth, -1.0f, FastColor.ARGB32.m_13660_((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.m_280091_());
        }
        poseStack.m_85849_();
        Objects.requireNonNull(mc.f_91062_);
        return 9;
    }

    public static int renderEntityArmour(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudArmour() : !TESAPI.getConfig().hudArmour()) {
            return 0;
        }
        int armour = TESUtil.getArmour(entity);
        if (armour <= 0) {
            return 0;
        }
        float toughness = TESUtil.getArmourToughness(entity);
        int textColour = FastColor.ARGB32.m_13660_((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        if (inWorldHud) {
            int totalWidth = toughness > 0.0f ? 43 + mc.f_91062_.m_92895_("x" + TESUtil.roundToDecimal(toughness, 1)) : mc.f_91062_.m_92895_("x" + armour) + 10;
            poseStack.m_252880_((float)totalWidth * -0.5f, 0.0f, 0.0f);
        }
        TESClientUtil.prepRenderForTexture(TESClientUtil.VANILLA_GUI_ICONS_LOCATION);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        TESClientUtil.drawSimpleTexture(guiGraphics, 0, 0, 9, 9, 34.0f, 9.0f, 256);
        if (toughness > 0.0f) {
            TESClientUtil.drawSimpleTexture(guiGraphics, 33, 0, 9, 9, 43.0f, 18.0f, 256);
        }
        (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.f_91062_, guiGraphics.m_280168_(), (Component)Component.m_237113_((String)("x" + armour)), 9.5f, 1.0f, textColour, guiGraphics.m_280091_());
        if (toughness > 0.0f) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.f_91062_, guiGraphics.m_280168_(), (Component)Component.m_237113_((String)("x" + TESUtil.roundToDecimal(toughness, 1))), 43.0f, 1.0f, textColour, guiGraphics.m_280091_());
        }
        poseStack.m_85849_();
        Objects.requireNonNull(mc.f_91062_);
        return 9;
    }

    public static int renderEntityIcons(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        MobType mobType;
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudEntityIcons() : !TESAPI.getConfig().hudEntityIcons()) {
            return 0;
        }
        int x = 0;
        TESClientUtil.prepRenderForTexture(ICONS_TEXTURE);
        if (TESUtil.isFireImmune((Entity)entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 0.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isMeleeMob(entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 8.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isRangedMob(entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 16.0f, 0.0f, 32);
            x += 9;
        }
        if ((mobType = entity.m_6336_()) != MobType.f_21640_) {
            int mobTypeU = mobType == MobType.f_21644_ ? 24 : (mobType == MobType.f_21643_ ? 16 : (mobType == MobType.f_21642_ ? 8 : 0));
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, mobTypeU, 8.0f, 32);
            x += 9;
        }
        return x == 0 ? 0 : 8;
    }

    public static int renderEntityEffects(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudPotionIcons() : !TESAPI.getConfig().hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        int effectsSize = entityState.getEffects().size();
        MobEffectTextureManager textureManager = mc.m_91306_();
        int barLength = inWorldHud ? TESAPI.getConfig().inWorldBarsLength() : TESAPI.getConfig().hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            poseStack.m_85837_(0.0, Math.floor((float)(effectsSize * 18) / maxX) * -18.0, 0.0);
        }
        for (ResourceLocation effectId : entityState.getEffects()) {
            TextureAtlasSprite sprite = textureManager.m_118732_((MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
            guiGraphics.m_280159_(i * 18 + x, y, 0, 18, 18, sprite);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        poseStack.m_85849_();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }
}

