/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.SwordItem;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import org.jetbrains.annotations.Nullable;

public interface TESUtil {
    public static final Object2BooleanOpenHashMap<Class<? extends LivingEntity>> meleeMobs = new Object2BooleanOpenHashMap();
    public static final Object2BooleanOpenHashMap<Class<? extends LivingEntity>> rangedMobs = new Object2BooleanOpenHashMap();

    public static String roundToDecimal(double value, int decimals) {
        float val = (float)Math.round(value * (double)((float)Math.pow(10.0, decimals))) / (float)Math.pow(10.0, decimals);
        if ((float)((int)val) == val) {
            return String.valueOf((int)val);
        }
        return String.valueOf(val);
    }

    public static float getHealthPercent(LivingEntity entity) {
        return entity.m_21223_() / entity.m_21233_();
    }

    public static int getArmour(LivingEntity entity) {
        if (entity.m_21204_().m_22171_(Attributes.f_22284_)) {
            return (int)Math.floor(entity.m_21133_(Attributes.f_22284_));
        }
        return 0;
    }

    public static float getArmourToughness(LivingEntity entity) {
        if (entity.m_21204_().m_22171_(Attributes.f_22285_)) {
            return (float)entity.m_21133_(Attributes.f_22285_);
        }
        return 0.0f;
    }

    public static boolean isFireImmune(Entity entity) {
        return entity.m_6095_().m_20672_();
    }

    public static boolean isMeleeMob(LivingEntity entity) {
        return TESUtil.isMeleeMobHardcoded(entity);
    }

    public static boolean isRangedMob(LivingEntity entity) {
        return TESUtil.isRangedMobHardcoded(entity);
    }

    public static boolean isVisibleToPlayer(LivingEntity entity, Player player) {
        return !entity.m_20177_(player) || entity.m_142038_();
    }

    public static boolean shouldTESHandleEntity(LivingEntity entity, Player player) {
        return !entity.m_6095_().m_204039_(TESConstants.NO_TES_HANDLING) && TESUtil.isVisibleToPlayer(entity, player);
    }

    @Nullable
    public LivingEntity getLivingEntityIfPossible(@Nullable Entity var1);

    public TESEntityType getEntityType(LivingEntity var1);

    public void clearDynamicCaches();

    private static boolean isMeleeMobHardcoded(LivingEntity entity) {
        return meleeMobs.computeIfAbsent(entity.getClass(), clazz -> {
            if (!entity.m_21204_().m_22171_(Attributes.f_22281_)) {
                return false;
            }
            if (entity.m_21172_(Attributes.f_22281_) != 2.0) {
                return true;
            }
            if (entity instanceof AbstractSkeleton) {
                AbstractSkeleton skeleton = (AbstractSkeleton)entity;
                return skeleton.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SwordItem;
            }
            return entity instanceof Phantom || entity instanceof EnderDragon || entity instanceof Spider || entity instanceof Slime || entity instanceof Endermite || entity instanceof Silverfish;
        });
    }

    private static boolean isRangedMobHardcoded(LivingEntity entity) {
        return rangedMobs.computeIfAbsent(entity.getClass(), clazz -> {
            if (entity instanceof RangedAttackMob) {
                return true;
            }
            if (entity instanceof Blaze || entity instanceof Shulker || entity instanceof Ghast || entity instanceof Guardian) {
                return true;
            }
            if (entity instanceof AbstractSkeleton) {
                AbstractSkeleton skeleton = (AbstractSkeleton)entity;
                return skeleton.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BowItem;
            }
            return false;
        });
    }
}

