/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.PartEntity.WitheredAbominationPartEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ShockwaveEntity;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Withered_AbominationEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Withered_AbominationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DROPPEDHORN1 = SynchedEntityData.m_135353_(Withered_AbominationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DROPPEDHORN2 = SynchedEntityData.m_135353_(Withered_AbominationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private final UUID uniqueID = UUID.randomUUID();
    private static final int STUN_COOLDOWN_DURATION = 160;
    private int stunCooldown = 0;
    private boolean isLandNavigator;
    private int arm1attackCooldown = 0;
    private int arm2attackCooldown = 35;
    private final WitheredAbominationPartEntity[] subEntities;
    private EndDragonFight dragonFight;
    @org.jetbrains.annotations.Nullable
    private Player unlimitedLastHurtByPlayer = null;
    public final WitheredAbominationPartEntity head;
    public int posPointer = -1;
    public final double[][] positions = new double[64][3];
    private int runcooldown = 0;
    private int smashCooldown = 0;
    private int SMASH_COOLDOWN = 60;
    public int AdditionalCharges = 3;
    public boolean shouldDoExtraDashes = true;
    private int timesToUseDash = 0;
    public int ChargeCount = 0;
    public AnimationState sweepComboLeftAnimationState = new AnimationState();
    public AnimationState sweepComboRightAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState attackarm1AnimationState = new AnimationState();
    public AnimationState attackarm2AnimationState = new AnimationState();
    public AnimationState attackarmsAnimationState = new AnimationState();
    public AnimationState attackstunAnimationState = new AnimationState();
    public AnimationState attackComboAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    public AnimationState runpreAnimationState = new AnimationState();
    public AnimationState postRunAnimationState = new AnimationState();
    public int nextSweepType = 1;
    private int abominationDeathTime;

    public Withered_AbominationEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.head = new WitheredAbominationPartEntity(this, "head", 1.0f, 1.0f);
        this.subEntities = new WitheredAbominationPartEntity[]{this.head};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    private void tickPart(WitheredAbominationPartEntity pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        pPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public UUID getUniqueID() {
        return this.uniqueID;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
        compound.m_128379_("DroppedHorn1", ((Boolean)this.f_19804_.m_135370_(DROPPEDHORN1)).booleanValue());
        compound.m_128379_("DroppedHorn2", ((Boolean)this.f_19804_.m_135370_(DROPPEDHORN2)).booleanValue());
        compound.m_128405_("StunCooldown", this.stunCooldown);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.f_19804_.m_135381_(DROPPEDHORN1, (Object)compound.m_128471_("DroppedHorn1"));
        this.f_19804_.m_135381_(DROPPEDHORN2, (Object)compound.m_128471_("DroppedHorn2"));
        this.stunCooldown = compound.m_128451_("StunCooldown");
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void performAreaAttack() {
        double attackRadius = 5.0;
        double attackHeight = 5.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_5448_().m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof CameraShakeEntity) continue;
            Vec3 entityPosition = livingEntity.m_20182_();
            livingEntity.m_20256_(new Vec3(0.0, 0.75, 0.0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 30, 2));
            this.m_7327_((Entity)livingEntity);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DROPPEDHORN1, (Object)false);
        this.f_19804_.m_135372_(DROPPEDHORN2, (Object)false);
    }

    public boolean canStun() {
        return this.stunCooldown <= 0;
    }

    public void resetStunCooldown() {
        this.stunCooldown = 160;
    }

    private void sendActionBarMessageToPlayer(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)message)));
        }
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @Override
    public void m_8119_() {
        ItemStack witheredHorn;
        Crackiness crackiness;
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.runcooldown > 0) {
            --this.runcooldown;
        }
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.stunCooldown > 0) {
            --this.stunCooldown;
        }
        if (this.arm1attackCooldown > 0) {
            --this.arm1attackCooldown;
        }
        if (this.arm2attackCooldown > 0) {
            --this.arm2attackCooldown;
        }
        this.UpdateWithAttack();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.getAttackState() == 0, this.f_19797_);
        }
        if (this.m_21224_()) {
            this.m_6153_();
        }
        this.updateAttributes();
        if (this.stunCooldown == 0 && (livingEntity = this.m_5448_()) instanceof Player) {
            Player pPlayer = (Player)livingEntity;
            if (this.m_5448_() != null) {
                // empty if block
            }
        }
        if ((crackiness = this.getCrackiness()) == Crackiness.MEDIUM && !((Boolean)this.f_19804_.m_135370_(DROPPEDHORN1)).booleanValue()) {
            this.playCrackSound();
            this.f_19804_.m_135381_(DROPPEDHORN1, (Object)true);
            witheredHorn = new ItemStack((ItemLike)ModItems.WITHERED_HORN.get(), 1);
            this.LGspawnatlocation(witheredHorn);
        }
        if (crackiness == Crackiness.HIGH && !((Boolean)this.f_19804_.m_135370_(DROPPEDHORN2)).booleanValue()) {
            this.playCrackSound();
            this.f_19804_.m_135381_(DROPPEDHORN2, (Object)true);
            witheredHorn = new ItemStack((ItemLike)ModItems.WITHERED_HORN.get(), 1);
            this.LGspawnatlocation(witheredHorn);
        }
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    private void playCrackSound() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12533_, SoundSource.NEUTRAL, 2.0f, 1.0f);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 15.0f, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public boolean getCrackinessMedium() {
        return this.getCrackiness() == Crackiness.MEDIUM;
    }

    public boolean getCrackinessHigh() {
        return this.getCrackiness() == Crackiness.HIGH;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public boolean isMediumCrackiness() {
        return this.getCrackiness() == Crackiness.MEDIUM;
    }

    public boolean isHighCrackiness() {
        return this.getCrackiness() == Crackiness.HIGH;
    }

    public boolean isLowCrackiness() {
        return this.getCrackiness() == Crackiness.LOW;
    }

    public boolean isNoneCrackiness() {
        return this.getCrackiness() == Crackiness.NONE;
    }

    public WitheredAbominationPartEntity[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return false;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    @SubscribeEvent
    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == 11 && this.attackTicks >= 0 && this.m_9236_().f_46443_) {
            float g = (float)Math.toRadians(-this.m_146908_() + 180.0f);
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            int numberOfSkulls = 1;
            float angleStep = 30.0f;
            float angle = this.m_146908_() + (float)(5 - numberOfSkulls / 2) * angleStep;
            float rad = (float)Math.toRadians(angle);
            double dx = -Math.sin(rad);
            double dz = Math.cos(rad);
            double spawnX = this.m_20185_() + vecX * 3.0;
            double spawnY = this.m_20186_() + 2.0;
            double d = this.m_20189_() + vecZ * 3.0;
        }
        if (this.getAttackState() == 11 && !this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            this.destroy();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 190.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 15.0);
    }

    private void faceTarget(LivingEntity target) {
        if (target != null) {
            double dx = target.m_20185_() - this.m_20185_();
            double dz = target.m_20189_() - this.m_20189_();
            double angle = Math.atan2(dz, dx) * 180.0 / Math.PI - 90.0;
            this.m_146922_((float)angle);
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
        }
    }

    public void attackTargets(Entity entity1) {
        LivingEntity livingEntity;
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 14.0 * (Double)ModConfig.MOB_CONFIG.WitheredAbominationDamageMutliplier.get();
        if (entity1 instanceof LivingEntity && ((livingEntity = (LivingEntity)entity1) instanceof Player || livingEntity instanceof ServerPlayer)) {
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 5.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 13.0));
            }
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.WitheredAbominationHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.WitheredAbominationDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 190.0;
        double baseAttackDamage = 14.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.WITHERED_ABOMINATION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WITHERED_ABOMINATION_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = this.SMASH_COOLDOWN;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 3.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 35, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 3 && Withered_AbominationEntity.this.getAttackState() != 5 && Withered_AbominationEntity.this.getAttackState() != 6 && Withered_AbominationEntity.this.getNextSweepType() == 1;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 35, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 5 && Withered_AbominationEntity.this.getAttackState() != 4 && Withered_AbominationEntity.this.getAttackState() != 6 && Withered_AbominationEntity.this.getNextSweepType() == 1;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 14, 0, 40, 40, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 3 && Withered_AbominationEntity.this.getAttackState() != 5 && Withered_AbominationEntity.this.getAttackState() != 6 && Withered_AbominationEntity.this.getNextSweepType() == 2;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 13, 0, 40, 40, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 5 && Withered_AbominationEntity.this.getAttackState() != 4 && Withered_AbominationEntity.this.getAttackState() != 6 && Withered_AbominationEntity.this.getNextSweepType() == 2;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 35, 15, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.smashCooldown <= 0 && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 3 && Withered_AbominationEntity.this.getAttackState() != 4 && Withered_AbominationEntity.this.getAttackState() != 5;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
                Withered_AbominationEntity.this.smashCooldown = 40;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 47, 15, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Withered_AbominationEntity.this.arm2attackCooldown <= 0 && Withered_AbominationEntity.this.m_5448_() != null && Withered_AbominationEntity.this.getAttackState() != 3 && Withered_AbominationEntity.this.getAttackState() != 4 && Withered_AbominationEntity.this.getAttackState() != 6;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Withered_AbominationEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Withered_AbominationEntity.this.m_5448_() != null) {
                        // empty if block
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
                Withered_AbominationEntity.this.arm2attackCooldown = 100;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 12, 10, 11, 20, 100){

            @Override
            public void m_8056_() {
                super.m_8056_();
                if (Withered_AbominationEntity.this.timesToUseDash > 0) {
                    --Withered_AbominationEntity.this.timesToUseDash;
                }
            }

            @Override
            public boolean m_8036_() {
                boolean originalCanUse = super.m_8036_();
                boolean hasAnyDashLeft = Withered_AbominationEntity.this.timesToUseDash > 0;
                LivingEntity target = Withered_AbominationEntity.this.m_5448_();
                boolean isTargetFarEnough = target != null && Withered_AbominationEntity.this.m_20270_((Entity)target) >= 5.0f;
                return originalCanUse && hasAnyDashLeft && isTargetFarEnough;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 10, 11, 7, 6, 15.0f, 2.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Withered_AbominationEntity.this.m_217043_().m_188501_() * 100.0f < 9.0f && Withered_AbominationEntity.this.runcooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.setTimesToUseDashBasedOnCrackiness();
            }

            @Override
            public void m_8056_() {
                Withered_AbominationEntity.this.shouldDoExtraDashes = true;
                super.m_8056_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 11, 11, 12, 20, 0){

            @Override
            public void m_8037_() {
                if (this.entity.m_20096_()) {
                    Vec3 vector3d = this.entity.m_20184_();
                    float f = this.entity.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.entity.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(0.5).m_82549_(vector3d.m_82490_(0.65));
                    this.entity.m_20334_(vector3d1.f_82479_, this.entity.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 11, 12, 0, 30, 40, 3.25f){

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.runcooldown = 40;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 12, 12, 0, 30, 40){

            @Override
            public void m_8041_() {
                super.m_8041_();
                Withered_AbominationEntity.this.randomizeAllAttackTypes();
                Withered_AbominationEntity.this.runcooldown = 40;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 25, 0, 15.0f));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setTimesToUseDashBasedOnCrackiness() {
        switch (this.getCrackiness()) {
            case HIGH: {
                this.timesToUseDash = 2;
                break;
            }
            case MEDIUM: {
                this.timesToUseDash = 1;
                break;
            }
            default: {
                this.timesToUseDash = 0;
            }
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "attackarm1") {
            return this.attackarm1AnimationState;
        }
        if (input == "attackarm2") {
            return this.attackarm2AnimationState;
        }
        if (input == "attackarms") {
            return this.attackarmsAnimationState;
        }
        if (input == "attackstun") {
            return this.attackstunAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "attackcombo") {
            return this.attackComboAnimationState;
        }
        if (input == "run") {
            return this.runAnimationState;
        }
        if (input == "runpre") {
            return this.runpreAnimationState;
        }
        if (input == "postrun") {
            return this.postRunAnimationState;
        }
        if (input == "sweepcomboright") {
            return this.sweepComboRightAnimationState;
        }
        if (input == "sweepcomboleft") {
            return this.sweepComboLeftAnimationState;
        }
        return new AnimationState();
    }

    private void launchControlledXYZ(LivingEntity entity, boolean huge, float PowerMultiplier, float yPower) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        float multiplier = huge ? PowerMultiplier : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? (double)yPower : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    public void randomizeAllAttackTypes() {
        this.getRandomSweepAnimation(2);
    }

    public int getNextSweepType() {
        return this.nextSweepType;
    }

    public void getRandomSweepAnimation(int rolls) {
        if (this.isNoneCrackiness()) {
            this.nextSweepType = 1;
        } else if (this.isLowCrackiness() || this.isHighCrackiness() || this.isMediumCrackiness()) {
            switch (this.f_19796_.m_188503_(rolls)) {
                case 0: {
                    this.nextSweepType = 1;
                    break;
                }
                case 1: {
                    this.nextSweepType = 2;
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackarm1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackarm2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.attackarmsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.attackstunAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.attackComboAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.postRunAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.runAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.runpreAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopAllAnimationStates();
                    this.sweepComboLeftAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 14: {
                    this.stopAllAnimationStates();
                    this.sweepComboRightAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.attackarmsAnimationState.m_216973_();
        this.attackstunAnimationState.m_216973_();
        this.attackarm1AnimationState.m_216973_();
        this.attackarm2AnimationState.m_216973_();
        this.attackComboAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.sweepComboRightAnimationState.m_216973_();
        this.sweepComboLeftAnimationState.m_216973_();
        this.postRunAnimationState.m_216973_();
        this.runAnimationState.m_216973_();
        this.runpreAnimationState.m_216973_();
    }

    public void m_6667_(DamageSource p_21014_) {
        this.abominationDeathTime = 0;
        super.m_6667_(p_21014_);
        ItemStack diamond = new ItemStack((ItemLike)ModItems.WITHERED_BONE.get(), 2);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, p_21014_.m_7639_());
        this.setAttackState(8);
    }

    public int deathtimer() {
        return 60;
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public boolean m_142066_() {
        return !this.isSleep() && super.m_142066_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268434_)) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    private void spawnShockwaves(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Withered_AbominationEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, true, 17.0f));
        }
    }

    public void UpdateWithAttack() {
        Vec3 entityPosition;
        float sweepRange = 4.5f;
        float sweepDamage = 16.5f;
        if (this.getAttackState() == 13) {
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(sweepRange, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, false);
            }
            if (this.attackTicks == 20) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(sweepRange + 0.1f, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, true);
            }
        }
        if (this.getAttackState() == 14) {
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(sweepRange, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, false);
            }
            if (this.attackTicks == 20) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(sweepRange + 0.1f, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, true);
            }
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(sweepRange, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, true);
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(sweepRange, 6.0f, 150.0f, sweepDamage, 100, false, 5, false, 0.25f, true);
            }
        }
        if (this.getAttackState() == 5) {
            int k;
            if (this.attackTicks == 24) {
                this.AreaAttack(7.0f, 6.0f, 160.0f, 21.0f, 140, false, 5, false, 0.75f, true);
                this.SpawnCircleParticle(3.5f, 0.0f, 30.0f, true, 0.8f, 1.0f, 1.0f, 1.0f, 1.0f);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    int standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (int k2 = 0; k2 < 6; ++k2) {
                        float f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                    }
                }
            }
            if (this.attackTicks == 27 && this.m_5448_() != null) {
                int standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 30 && this.m_5448_() != null) {
                int standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 0);
                }
            }
            if (this.attackTicks == 33 && this.m_5448_() != null) {
                int standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 19; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 0);
                }
            }
        }
        if (this.getAttackState() == 12 && this.attackTicks == 3) {
            this.AreaAttack(6.0f, 4.0f, 120.0f, 15.0f, 120, false, 1, false, 0.75f, true);
        }
        if (this.getAttackState() == 8) {
            if (this.attackTicks == 20) {
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
            if (this.attackTicks == 20) {
                // empty if block
            }
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 16 && this.m_20096_()) {
                LivingEntity target = this.m_5448_();
                if (this.m_5448_() != null) {
                    assert (target != null);
                    double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    if (distanceToTarget > 16.0) {
                        Vec3 vector3d = this.m_20184_();
                        float f = this.m_146908_() * ((float)Math.PI / 180);
                        Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(1.8).m_82549_(vector3d.m_82490_(1.5));
                        this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                    }
                }
            }
            if (this.attackTicks == 22) {
                this.AreaAttack(6.0f, 4.0f, 180.0f, 15.0f, 60, false, 1, false, 0.75f, true);
            }
        }
        if (this.getAttackState() == 9) {
            if (this.attackTicks == 17) {
                this.AreaAttack(6.0f, 4.0f, 60.0f, 10.0f, 30, false, 5, false, 0.4f, true);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 50) {
                this.AreaAttack(6.0f, 4.0f, 60.0f, 10.0f, 30, false, 5, false, 0.4f, true);
                this.Makeparticle(0.5f, 9.0f, 1.2f);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 57) {
                this.m_5496_((SoundEvent)ModSounds.WITHERED_ABOMINATION_DASH2.get(), 15.0f, 1.0f);
            }
            if (this.attackTicks == 60) {
                if (!(this.m_5448_() instanceof Player) && this.m_5448_() != null) {
                    DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
                    this.m_5448_().m_6469_(damageSource, 16.0f);
                }
                if (this.m_20096_()) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(1.5).m_82549_(vector3d.m_82490_(1.3));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
            if (this.attackTicks == 66) {
                this.AreaAttack(4.0f, 4.0f, 60.0f, 14.0f, 60, true, 1, true, 0.75f, false);
                this.Makeparticle(0.5f, 9.0f, 1.2f);
            }
        }
    }

    private void destroy() {
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        Iterator var3 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
        while (var3.hasNext()) {
            BlockPos blockpos = (BlockPos)var3.next();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate) || this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) continue;
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
        return;
    }

    private void Makeparticle(float size, float vec, float math) {
        if (!this.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(6); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = size * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = size * Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), 1, DeltaMovementX, DeltaMovementY, DeltaMovementZ, 0.0);
            }
        }
    }

    @Override
    public void launch(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        float multiplier = huge ? 2.0f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, 0.35, deltaZ / distanceSquared * (double)multiplier);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, int knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Withered_AbominationEntity || entityHit == this) continue;
            boolean hurt = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.WitheredAbominationDamageMutliplier.get()));
            if (!entityHit.m_21254_()) {
                if (hurt && launch) {
                    if (this.getAttackState() != 13 || this.getAttackState() != 14) {
                        this.launch(entityHit, true);
                    }
                    if (this.getAttackState() == 13 || this.getAttackState() == 14) {
                        this.launch(entityHit, true);
                    }
                    if (this.getAttackState() == 12) {
                        this.launch(entityHit, true);
                    }
                }
                if (hurt) {
                    if (this.getAttackState() == 4 || this.getAttackState() == 3 || this.getAttackState() == 14 || this.getAttackState() == 13) {
                        this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 0.5f);
                    }
                    entityHit.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 40, 1), (Entity)this);
                }
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            Withered_AbominationEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    protected void m_6153_() {
        ++this.abominationDeathTime;
        if (this.abominationDeathTime == 35) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.abominationDeathTime == 100 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.WITHERED_BONE.get(), 2);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

