/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data.recipes;

import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class MNDCuttingRecipes {
    public static void register(Consumer<FinishedRecipe> consumer) {
        MNDCuttingRecipes.cuttingAnimalItems(consumer);
        MNDCuttingRecipes.strippingWood(consumer);
        MNDCuttingRecipes.salvagingWoodenFurniture(consumer);
        MNDCuttingRecipes.cuttingVegetables(consumer);
        MNDCuttingRecipes.cuttingFoods(consumer);
    }

    private static void cuttingAnimalItems(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASTA.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.GHASMATI.get())).addResultWithChance((ItemLike)MNDItems.GHASMATI.get(), 0.05f).build(consumer, "mynethersdelight:cutting/ghasmati");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.STRIDER_ROCK.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_PICKAXES), (ItemLike)((ItemLike)MNDItems.STRIDER_EGG.get())).addResultWithChance((ItemLike)Items.f_42499_, 0.25f).build(consumer, "mynethersdelight:cutting/strider_egg");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.STRIDER_SLICE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.MINCED_STRIDER.get()), (int)2).addResult((ItemLike)Items.f_42401_).addResultWithChance((ItemLike)Items.f_42401_, 0.5f, 2).build(consumer, "mynethersdelight:cutting/minced_strider");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.HOGLIN_SAUSAGE.get()), (int)2).build(consumer, "mynethersdelight:cutting/hoglin_sausage");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_HIDE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42454_, (int)4).addResultWithChance((ItemLike)Items.f_42454_, 0.5f, 2).build(consumer, "mynethersdelight:cutting/hoglin_hide");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42585_}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42593_, (int)3).addResultWithChance((ItemLike)Items.f_42593_, 0.25f, 1).build(consumer, "mynethersdelight:cutting/balze_rod");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_TROPHY.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.SKOGLIN_TROPHY.get())).addResult((ItemLike)Items.f_42454_).addResultWithChance((ItemLike)Items.f_42454_, 0.5f, 2).build(consumer, "mynethersdelight:cutting/skoglin_trophy");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.ZOGLIN_TROPHY.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.SKOGLIN_TROPHY.get())).addResult((ItemLike)Items.f_42583_).addResultWithChance((ItemLike)Items.f_42583_, 0.5f, 2).build(consumer, "mynethersdelight:cutting/skoglin_trophy_alt");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.WAXED_HOGLIN_TROPHY.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_AXES), (ItemLike)((ItemLike)MNDItems.HOGLIN_TROPHY.get())).build(consumer, "mynethersdelight:cutting/hoglin_trophy");
    }

    private static void strippingWood(Consumer<FinishedRecipe> consumer) {
        MNDCuttingRecipes.stripLogForBark(consumer, (ItemLike)MNDItems.BLOCK_OF_POWDERY_CANNON.get(), (ItemLike)MNDItems.BLOCK_OF_STRIPPED_POWDERY_CANNON.get());
    }

    private static void salvagingWoodenFurniture(Consumer<FinishedRecipe> consumer) {
        MNDCuttingRecipes.salvagePlankFromFurniture(consumer, (ItemLike)MNDItems.POWDERY_PLANKS.get(), (ItemLike)MNDItems.POWDERY_DOOR.get(), (ItemLike)MNDItems.POWDERY_TRAPDOOR.get(), (ItemLike)MNDItems.POWDERY_SIGN.get());
    }

    private static void cuttingVegetables(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42501_, (int)1).addResultWithChance((ItemLike)Items.f_42501_, 0.25f, 1).build(consumer, "farmersdelight:cutting/sugar_cane_alt");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42047_}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.PUMPKIN_SLICE.get()), (int)1).addResultWithChance((ItemLike)Items.f_42577_, 0.25f, 1).build(consumer, "farmersdelight:cutting/pumpkin_slice_alt");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42403_, (int)1).addResultWithChance((ItemLike)Items.f_42403_, 0.25f, 1).build(consumer, "mynethersdelight:cutting/gunpowder_cane");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BULLET_PEPPER.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42593_, (int)1).addResultWithChance((ItemLike)Items.f_42593_, 0.25f, 1).build(consumer, "mynethersdelight:cutting/bullet_pepper");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.CRIMSON_FUNGUS_COLONY.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_41954_, (int)5).build(consumer, "mynethersdelight:cutting/crimson_fungus");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.WARPED_FUNGUS_COLONY.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_41955_, (int)5).build(consumer, "mynethersdelight:cutting/warped_fungus");
    }

    private static void cuttingFoods(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.MAGMA_CAKE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)MNDItems.MAGMA_CAKE_SLICE.get()), (int)7).build(consumer, "mynethersdelight:cutting/magma_cake");
    }

    private static void stripLogForBark(Consumer<FinishedRecipe> consumer, ItemLike log, ItemLike strippedLog) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_STRIP), (ItemLike)strippedLog).addResult((ItemLike)ModItems.STRAW.get()).addSound(Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_11688_)).toString()).build(consumer);
    }

    private static void salvagePlankFromFurniture(Consumer<FinishedRecipe> consumer, ItemLike plank, ItemLike door, ItemLike trapdoor, ItemLike sign) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{door}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{trapdoor}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{sign}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer);
    }
}

